<div class="alert alert-info">
	<i class="fa fa-info"></i>

	<?php
    // The base url is the url where we'll pass the filter parameters
    $base_url = array('controller' => 'stats', 'action' => 'location');
    echo $this->Form->create('Filter', array(
        'url' => $base_url,
        'class' => 'form-inline',
        'inputDefaults' => array(
            //'label' => false,
            'div' => 'form-group',
            'class' => 'form-control input-sm',
            'error' => array(
                'attributes' => array('wrap' => 'span', 'class' => 'help-block')
            ),
        ),
    ));
    ?>

    <?php echo $this->Form->input('date_from', array('type' => 'date', 'placeholder' => __('From'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->input('date_to', array('type' => 'date', 'placeholder' => __('To'), 'minYear' => date('Y') - 3, 'maxYear' => date('Y'))); ?>

    <?php echo $this->Form->submit('Filter', array('div' => false, 'class' => 'btn btn-default btn-sm')); ?>
    <?php echo $this->Html->link('Reset', $base_url); ?>
    <?php echo $this->Form->end(); ?>

</div>


<!-- Info box -->
<div class="box box-info">
    <div class="box-header">
        <i class="glyphicon glyphicon-stats"></i> <h3 class="box-title">Clicks</h3>
    </div>
    <div class="box-body">
        <div class="chart" id="last-month-hits" style="position: relative; height: 300px; width: 100%;"></div>
    </div><!-- /.box-body -->
</div><!-- /.box -->

<hr>

<div class="box box-success">
    <div class="box-header">
        <h3 class="box-title">Countries</h3>
    </div>
    <div class="box-body">
        <div class="row">
            <div class="col-sm-8">
                <div id="countries_geochart" style="position: relative; height: 300px; width: 100%;"></div>
            </div>
            <div class="col-sm-4" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_countries as $link_country) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_country['Stat']['country'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_country['0']['country_num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($country);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<hr>

<div class="row">
    <div class="col-sm-4">
        <div class="box box-info">
            <div class="box-header">
                <h3 class="box-title">Continents</h3>
            </div>
            <div class="box-body" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_continents as $link_continent) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_continent['Stat']['continent'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_continent[0]['continent_num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($link_continent);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="box box-info">
            <div class="box-header">
                <h3 class="box-title">States</h3>
            </div>
            <div class="box-body" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_states as $link_state) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_state['Stat']['state'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_state[0]['state_num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($link_state);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="box box-info">
            <div class="box-header">
                <h3 class="box-title">Cities</h3>
            </div>
            <div class="box-body" style="height: 300px;overflow: auto;">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Clicks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($link_cities as $link_city) {
                            echo '<tr>';
                            echo '<td>';
                            echo $link_city['Stat']['city'];
                            echo '</td>';
                            echo '<td>';
                            echo $link_city[0]['city_num'];
                            echo '</td>';
                            echo '</tr>';
                        }
                        unset($link_city);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<script>

    jQuery(document).ready(function () {
        new Morris.Bar({
            element: 'last-month-hits',
            resize: true,
            data: [
<?php
$startTime = strtotime($date_from_str);
$endTime = strtotime($date_to_str);
$days_range = array();

for ($i = $startTime; $i <= $endTime; $i = $i + 86400) {
    $days_range[date('d-m-Y', $i)] = 0;
}

foreach ($linksStats as $linksStat) {
    if (empty($linksStat[0]["statDateCount"])) {
        $linksStat[0]["statDateCount"] = 0;
    }
    $days_range[$linksStat[0]["statDate"]] = $linksStat[0]["statDateCount"];
}

foreach ($days_range as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", clicks: ' . $value . '},';
}
?>
            ],
            xkey: 'date',
            xLabels: 'day',
            ykeys: ['clicks'],
            labels: ['Clicks'],
            lineWidth: 2,
            hideHover: 'auto',
            stacked: true
        });


    });



</script>

<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<script type='text/javascript'>
    google.load('visualization', '1', {'packages': ['geochart']});
    google.setOnLoadCallback(drawRegionsMap);

    function drawRegionsMap() {
        var data = google.visualization.arrayToDataTable([
            ['Country', 'Clicks'],
<?php
foreach ($link_countries as $link_country) {
    echo '["' . $link_country["Stat"]["country"] . '", ' . $link_country[0]["country_num"] . '],';
}
?>
        ]);

        var options = {};

        var chart = new google.visualization.GeoChart(document.getElementById('countries_geochart'));
        chart.draw(data, options);
    }
    ;
</script>


